# Contributing to Phalcon

Phalcon is a volunteer-driven open-source project that encourages contributions 
from all. Kindly take a moment to go through this document to facilitate a 
smooth and effective contribution process for everyone.

Adhering to these guidelines demonstrates your consideration for the time and 
efforts of the developers who oversee and advance this open-source project. 
In return, they are expected to reciprocate this respect when addressing your 
issues or evaluating patches and features.

## Contributions

Please submit contributions to Phalcon through GitHub pull requests. Each pull 
request will undergo review by a core contributor, someone with the authority 
to merge patches. Feedback may be given, and changes might be requested, or 
the pull request will be merged. It is essential that all contributions, 
including those from core contributors, adhere to this format.

## Questions & Support

We utilize GitHub issues to track bugs and feature requests, but due to limited 
bandwidth, we can't address all of them. Consequently, we only accept bug 
reports, new feature requests, and pull requests through GitHub. However, our 
vibrant community and contributors are eager to assist you! Kindly utilize 
these community resources for obtaining help.

_Prioritize consulting the [Documentation](https://phalcon.io/docs) before any other resource. 
Additionally, you can employ the search feature in our documents to locate the 
information you seek. If your question remains unanswered, explore the 
additional options provided below._

*   Questions should go to [GitHub Discussions](https://phalcon.io/discussions)
*   Another way is to ask a question on [Stack Overflow](https://stackoverflow.com/) and tag it with [`phalcon`](https://stackoverflow.com/questions/tagged/phalcon)
*   Come join the Phalcon [Discord](https://phalcon.io/discord)
*   Our social network accounts are:
  -   [Telegram](https://phalcon.io/telegram)
  -   [Gab](https://phalcon.io/gab)
  -   [MeWe](https://phalcon.io/mewe)
  -   [Twitter](https://phalcon.io/t)
  -   [Facebook](https://phalcon.io/fb)
*   If you still believe that what you found is a bug, please [open an issue](https://github.com/phalcon/cphalcon/issues/new)

Please report bugs when you've exhausted all of the above options.

## Requesting Features

If you have a change or new feature in mind, please fill a [NFR](https://docs.phalcon.io/en/latest/new-feature-request) on GitHub.

Thanks! 
Phalcon Team
